//
//  Client.h
//  Harding_MyOCR
//
//  Created by tamara7777 on 4/13/13.
//  Copyright (c) 2013 tamara7777. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HTTPOperation.h"
#import "ProcessingParams.h"

@protocol ClientDelegate;

@interface Client : NSObject<HTTPOperationAuthenticationDelegate> {
    
}

@property (strong, nonatomic) NSString* applicationID;
@property (strong, nonatomic) NSString* password;

@property (assign) id<ClientDelegate> delegate;

- (id)initWithApplicationID:(NSString*)applicationID password:(NSString*)password;
- (void)processImage:(UIImage*)image withParams:(ProcessingParams*)params;

@end

@protocol ClientDelegate <NSObject>

@optional

- (void)clientDidFinishUpload:(Client*)sender;
- (void)clientDidFinishProcessing:(Client*)sender;
- (void)client:(Client*)sender didFinishDownloadData:(NSData*)downloadedData;
- (void)client:(Client*)sender didFailedWithError:(NSError*)error;

@end